﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace Rozdział_36
{
    class HospitalStaff : IEnumerable<string>
    {
        public string Doctor { get; set; }
        public string Nurse { get; set; }
        public string Intern1 { get; set; }
        public string Intern2 { get; set; }

        public IEnumerator<string> GetEnumerator()
        {
            return new HospitalStaffEnumerator(this);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }

        private class HospitalStaffEnumerator : IEnumerator<string>
        {
            private HospitalStaff m_hospStaff;
            private int m_currentPos;
            private string m_currentVal = string.Empty;
            private const int Doctor = 0;
            private const int Nurse = 1;
            private const int Intern1 = 2;
            private const int Intern2 = 3;

            public HospitalStaffEnumerator(HospitalStaff hospStaff)
            {
                m_hospStaff = hospStaff;
            }

            public void Reset()
            {
                m_currentPos = -1;
            }

            public bool MoveNext()
            {
                if (m_currentPos == Intern2)
                {
                    return false;
                }

                ++m_currentPos;

                switch (m_currentPos)
                {
                    case Doctor:
                        m_currentVal = m_hospStaff.Doctor;
                        break;
                    case Nurse:
                        m_currentVal = m_hospStaff.Nurse;
                        break;
                    case Intern1:
                        m_currentVal = m_hospStaff.Intern1;
                        break;
                    case Intern2:
                        m_currentVal = m_hospStaff.Intern2;
                        break;
                    default:
                        string message =
                            m_currentPos < 0 ?
                            "Wywołanie MoveNext przed odczytem Current" :
                            "Po odczytaniu wszystkich danych trzeba wywołać Reset lub GetEnumerator";
                        throw new IndexOutOfRangeException(message);
                }

                return true;
            }

            public string Current
            {
                get { return m_currentVal; }
            }

            object IEnumerator.Current
            {
                get { throw new NotImplementedException(); }
            }

            public void Dispose()
            {
                throw new NotImplementedException();
            }
        }
    }
}
